var socket;
var new_uri;
var termId;
var contextRoot;
var replContextRoot;
//$(document).ready(init);

isLoading=false;
//isloadingOverlay();

const waitForOpenConnection = (socket) => {
    return new Promise((resolve, reject) => {
        const maxNumberOfAttempts = 10
        const intervalTime = 200 //ms

        let currentAttempt = 0
        const interval = setInterval(() => {
            if (currentAttempt > maxNumberOfAttempts - 1) {
                clearInterval(interval)
                reject(new Error('Maximum number of attempts exceeded'))
            } else if (socket.readyState === socket.OPEN) {
                clearInterval(interval)
                resolve()
            }
            currentAttempt++
        }, intervalTime)
    })
}

const sendMessage = async (socket, msg) => {
    if (socket.readyState !== socket.OPEN) {
        try {
            await waitForOpenConnection(socket)
            socket.send(msg)
        } catch (err) { console.error(err) }
    } else {
        socket.send(msg)
    }
}

function init() {
    isloadingOverlay();
    var loc = window.location;
    var pathArray = loc.pathname.split( '/' );
    
    if (loc.protocol === "https:") {
        new_uri = "wss:";
    } else {
        new_uri = "ws:";
    }
    new_uri += "//" + loc.host;
    contextRoot = "";
    if (pathArray[1] !== "servlet") {    
        contextRoot = pathArray[1];
        new_uri += "/" + contextRoot;
    }
    new_uri += "/terminalwebsocket";
    
    if (contextRoot !== "") {
        replContextRoot = "/" + contextRoot;
    } else {
        replContextRoot = "";
    }
    
    connect();

}

function connect(){
    try{
        socket = new WebSocket(new_uri);
        
        socket.onopen = sendMessage(socket, termId);

        socket.onmessage = function(event){
            socket.close();
            // similar behavior as an HTTP redirect
            window.location.replace(replContextRoot + event.data);
        }
        socket.onclose = function(){
               //message('<p class="event">Socket Status: '+socket.readyState+' (Closed)');
        }            

   } catch(exception){
       console.log(exception);
   }
}
